<?php
/**
 * @version		$Id: notify.php 151 2010-03-01 19:43:01Z mathias $
 * @category	DOCman
 * @package		DOCmanNotify
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

// requires
define('NOTIFY_PATH', dirname(__FILE__));
require_once NOTIFY_PATH.DS.'includes'.DS.'config.php';

jimport( 'joomla.plugin.plugin' );
class plgDocmanNotify extends JPlugin
{
	public function __construct($subject, $config = array())
	{
		$this->loadLanguage('plg_docman_notify', JPATH_ADMINISTRATOR);
		parent::__construct($subject, $config = array());
	}

	public function onAfterUpload($params)
	{
		return $this->_notify($params);
	}

	public function onAfterEditDocument($params)
	{
		return $this->_notify($params);
	}

	public function onBeforeDownload($params)
	{
		return $this->_notify($params);
	}


	protected function _notify($params)
	{
		require_once NOTIFY_PATH.DS.'includes'.DS.'emailtemplate.php';

		$email = new NotifyEmailTemplate( $params );

	    switch($params['process'])
	    {
	    	case 'new document':
	    	case 'edit document':
	    		$action = 'edit';
	    		$actionlang = $email->user->name.' '.JText::_('PLG_DOCMAN_NOTIFY_EDITED').' '.$email->site->name;
	    		break;
	    	case 'upload':
	    		$action = 'upload';
	    		$actionlang = $email->user->name.' '.JText::_('PLG_DOCMAN_NOTIFY_UPLOADED').' '.$email->site->name;
	    		break;
	    	case 'download':
	    		$action = 'download';
	    		$actionlang = $email->user->name.' '.JText::_('PLG_DOCMAN_NOTIFY_DOWNLOADED').' '.$email->site->name;
	    		break;

	    }

	    $cfg =  NotifyConfig::getInstance();

	    // is the action activated in the plugin params?
	    if( ! $cfg->doAction($action) ) {
	        return;
	    }

	    $email->action		= $action;
	    $email->actionlang	= $actionlang;
	    $email->setSubject($actionlang );
	    $email->send();
	}
}
