<?php
/**
 * @version		$Id: docmandocument.php 181 2010-06-15 11:36:47Z mathias $
 * @category	DOCman
 * @package		DOCmanNotify
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

require_once NOTIFY_PATH.DS.'includes'.DS.'docmandata.php';

class NotifyDocument  extends NotifyDocmanData
{
    protected $_key = 'document';

    /**
     * Populate object with data from docman
     */
    protected function _loadParams()
    {
        // load normal document variables
        $vars = array( 'catid', 'id', 'dmname', 'dmdescription', 'dmdate_published', 'dmowner', 'dmfilename',
                       'dmurl', 'dmcounter', 'checked_out_time', 'dmlastupdateon', 'dmlicense_id', 'access');
        foreach( $vars as $var ) {
            $this->_load( $var );
        }


        // load boolean document variables
        $vars = array( 'published', 'checked_out', 'approved', 'dmlicense_display');
        foreach( $vars as $var ) {
            $this->_loadBool( $var );
        }

        // load user related document variables
        $vars = array( 'dmowner', 'dmlastupdateby', 'dmsubmitedby', 'dmmantainedby');
        foreach( $vars as $var ) {
            $this->_loadUser( $var );
        }

        // link
        $ssl = (JFactory::getApplication()->getCfg('force_ssl') == 2) ? 1 : -1;
        $this->link = JRoute::_('index.php?option=com_docman&task=doc_details&gid='.$this->id, 0, $ssl);

		// Category
		global $_DOCMAN;
		require_once $_DOCMAN->getPath('classes', 'model');
		$cat = new DOCMAN_Category($this->catid);
		$this->category = $cat->objDBTable->title;
    }

}