<?php
/**
 * @version		$Id: DOCMAN_button.class.php 955 2009-10-14 20:38:38Z mathias $
 * @category	DOCman
 * @package		DOCman15
 * @copyright	Copyright (C) 2003 - 2012 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

class com_docmanInstallerScript
{
	protected static $_config = '/administrator/components/com_docman/docman.config.php';
	protected static $_config_temp = '/administrator/components/com_docman/docman.config.temp.php';
	 
	public function preflight($type, $installer)
	{
		if ($type === 'update') {
			$args[] = true;
		}
		
		if (file_exists(JPATH_ROOT.self::$_config)) {
			copy(JPATH_ROOT.self::$_config, JPATH_ROOT.self::$_config_temp);
		}
	}
	
	public function postflight($type, $installer)
	{
		if (file_exists(JPATH_ROOT.self::$_config_temp)) {
			rename(JPATH_ROOT.self::$_config_temp, JPATH_ROOT.self::$_config);
		}
		
		if (!class_exists('DMInstallHelper')) {
			require_once dirname(__FILE__).'/helper.php';
		}
		
		// Joomla's archive handler eats a lot of memory
		if((int) ini_get('memory_limit') < 24) {
			@ini_set('memory_limit', '24M');
		}
	
		$lang = JFactory::getLanguage();
		$lang->load('com_installer');
	
		$tasks = array('copyFiles', 'insertInDb', 'cpanel', 'track' );
		$status = & DMStatus::getInstance();
		
		$args = array();
		if ($type === 'update') {
			$args[] = true;
		}
		
		while($status->get() && $task = array_shift($tasks))
		{
			call_user_func_array(array('DMInstallHelper', $task), $args);
		}
	
		echo '<ul>';
		foreach($status->getMsgs() as $msg) {
			echo '<li>'.$msg.'</li>';
		}
		echo '</ul>';
		return $status->get();
	}	
	
	public function uninstall($installer)
	{
		if (!class_exists('DMInstallHelper')) {
			require_once dirname(__FILE__).'/helper.php';
		}
		
		$lang = JFactory::getLanguage();
		$lang->load('com_installer');

		DMInstallHelper::removeFiles();
		DMInstallHelper::deleteFromDb();

		// if there's no more data, we remove the tables
		if( DMInstallHelper::cntDbRecords() == 0 ) {
			DMInstallHelper::removeTables();
		}

		// delete the data folder if it's empty
		if ( DMInstallHelper::cntFiles() == 0 ) {
			DMInstallHelper::removeDmdocuments();
		}
	}
}