<?php
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class DocmanExportController extends JController
{
	protected $_redirectURL = 'index.php?option=com_docman_export';

	public function display()
	{
		$document = &JFactory::getDocument();

		$vName		= JRequest::getWord('view', 'export');
		$vFormat	= $document->getType();
		$lName		= JRequest::getWord('layout', 'default');

		if ($view = &$this->getView($vName, $vFormat)) {
			switch ($vName) {
				default:
					$model = &$this->getModel($vName);
					break;
			}

			if (!empty($model)) {
				$view->setModel($model, true);
			}
			$view->setLayout($lName);

			$view->assignRef('document', $document);

			$view->display();
		}
	}

	protected function _serve(SplFileObject $file, $filename = null) {
    	header('Content-Type: application/octet-stream');
    	header('Content-Disposition: attachment; filename='.($filename === null ? $file->getFilename() : $filename));
    	header('Content-Length: '.$file->ftell());
		
		$file->rewind();

		foreach ($file as $line) {
			echo $line;
		}
		
		JFactory::getApplication()->close();
	}
	
	protected function export_config()
	{
		require_once JPATH_ADMINISTRATOR.'/components/com_docman/docman.config.php';
		$config = new dmConfig;
		$config = (array) $config;

		$app = JApplication::getInstance('site');
		$component	= &JComponentHelper::getComponent('com_docman');
		$menu		= $app->getMenu();
		$items		= $menu->getItems('componentid', $component->id);
		
		jimport('joomla.application.module.helper');
		$db = JFactory::getDBO();
		$db->setQuery("SELECT * FROM #__modules WHERE module LIKE 'mod_docman%' AND client_id = 0");
		$modules = $db->loadObjectList();
		foreach ($modules as &$module) {
			$module->params = $this->_convertToArray($module->params);
		}
		
		foreach ($items as &$menu) {
			$menu->params = $this->_convertToArray($menu->params);
		}	

		$obj = new stdclass;
		$obj->version = '1.5';
		$obj->config = $config;
		$obj->menus = $items;
		$obj->modules = $modules;
		
		$file = new SplTempFileObject();
		$file->fwrite(serialize($obj));
		
		return $this->_serve($file, 'docman_export.dcm');
	}
	
	protected function _convertToArray($ini)
	{
		$params = preg_split("#\\n#", $ini, -1, PREG_SPLIT_NO_EMPTY);
		$arr = array();
		foreach ($params as &$param) {
			list($key, $value) = explode('=', $param, 2);
			$arr[$key] = $value;
		}
		return $arr;
	}
	
	public function export_data()
	{
		$config = new JConfig;
		
		$this->prefix = $config->dbprefix;
		
		$this->db = mysql_connect($config->host, $config->user, $config->password) or die(mysql_error());
		mysql_select_db($config->db, $this->db) or die(mysql_error());
		
		$file = new SplTempFileObject();
		$this->_exportCategoriesSchema($file);
		$this->_exportCategories($file);

		$tables = array(
			'#__docman',
			'#__docman_groups',
			'#__docman_history',
			'#__docman_licenses',
			'#__docman_log'
		);	
		foreach ($tables as $table) {
			$query = "SELECT * FROM $table";
			$this->_exportFromQuery($query, $table, $file);
		}
		
		$this->_exportACLQuery($file);

		return $this->_serve($file, 'docman_export.sql');
	}
	
	protected function _exportCategoriesSchema(&$file)
	{
		$file->fwrite("
CREATE TABLE IF NOT EXISTS `#__docman_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `section` varchar(50) NOT NULL DEFAULT '',
  `image_position` varchar(30) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`section`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`)
) ENGINE=MyISAM;
		");
	}
	
	protected function _exportACLQuery(&$file)
	{
		$file->fwrite("
UPDATE #__docman SET access = access + 1;
UPDATE #__docman_categories SET access = access + 1;
		");
	}	
	
	protected function _exportCategories(&$file)
	{
		$query = "SELECT * FROM #__categories WHERE section = 'com_docman'";
		$this->_exportFromQuery($query, '#__docman_categories', $file);
	}
	
	protected function _exportFromQuery($query, $target_table, $file)
	{
		$query = $this->_query($query);
		
		$count = mysql_num_rows($query);
		if ($count == 0) {
			return;
		}
		
		$i = 0;
		while ($row = mysql_fetch_array($query)) {
			$str = '';
			if ($i % 20 === 0) {
				$str .= "\nREPLACE INTO $target_table VALUES\n";
			}
			
			$str .= '(';
			for ($j = 0, $k = count($row)/2; $j < $k; $j++) {
				$field = $row[$j];
				$field = mysql_real_escape_string($field, $this->db);
				$str .= "'$field',";
			}
			$str = substr($str, 0, -1).')';

			$str .= (($i+1) % 20 == 0 || $i+1 == $count ? ';' : ',');
			$str .= "\n";

			$file->fwrite($str);
			$i++;
		}
	}
	
	protected function _query($query)
	{
		$query = str_replace('#__', $this->prefix, $query);
		$result = mysql_query($query, $this->db);
		
		return $result;
	}
}
