<?php
/**
 * @version		$Id$
 * @category	DOCmanPopulate
 * @package		DOCmanPopulate15
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_populate'.DS.'models'.DS.'files.php';
require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_populate'.DS.'helpers'.DS.'formatter.php';
require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_populate'.DS.'tables'.DS.'config.php';
require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_populate'.DS.'tables'.DS.'params.php';


jimport( 'joomla.application.component.controller' );
class PopulateControllerDocuments extends JController
{	
	public function assign()
	{
		$_DOCMAN = PopulateDocman::get();
		$my 		= JFactory::getUser();
        $db 	= JFactory::getDBO();

        $apConfig   = TablePopulateConf::getInstance();
        $apParams   = TablePopulateParams::getInstance();

        $files = array();
        $success = 0; $failed = 0;
        		
		$filesmodel = new PopulateModelFiles;

        $FilesInDatabase    = $filesmodel->getData(); //files that already have a doc entry
        if($FilesInDatabase===false) {
        	die('Error reading file list from database');
        }
        
        // if not set in config, get defaults
        $dmowner        = $apConfig->dmowner        ? $apConfig->dmowner        : $apParams->dmowner;
        $dmmantainedby  = $apConfig->dmmantainedby  ? $apConfig->dmmantainedby  : $apParams->dmmantainedby;

        if ( $apParams->dmpath == '' ) {
            die("Please go to the DOCman configuration first, check all settings and make sure to <b>save</b>, even if you change nothing." );
            return;
        }
        
        if ( !$handle = opendir($apParams->dmpath) ) {
            die( "Problem opening dmdocuments directory " . $apParams->dmpath
                    .". Make sure you have DOCman working correctly before using this component." );
            return;
        }


        while (false !== ($file = readdir($handle))) 
        {
            if (    !in_array($file, explode( "|", $apConfig->skipfiles ) )
                    && !in_array($file, $FilesInDatabase)
                    && !is_dir($file) ) {
                $files[] = $file;
            }
        }

        foreach ($files as $file) 
        {
            $title = $apConfig->stripextension ? PopulateFormatter::stripExtension( $file ) : $file;
            $title = $apConfig->nicetitle ? PopulateFormatter::getNiceTitle( $title ) : $title;

            // filetimes
            $dmdate_published = $apParams->dmdate_published;
            $dmlastupdateon = $apParams->dmlastupdateon;
            if ($apConfig->usefiletime) {
                $st = @stat($apParams->dmpath.'/'.escapeshellarg($file));
                if ($st) {
                    $dmdate_published = strftime('%Y-%m-%d %T', $st[10]);
                    $dmlastupdateon = strftime('%Y-%m-%d %T', $st[9]);
                }
            }

             $db->setQuery(
                    "INSERT INTO `#__docman` "
                    ."\n SET "
                    ." \n `dmfilename`			= ".$db->quote($file)
                    .",\n `dmname`				= ".$db->quote($title)
                    .",\n `catid`				= ".(int) $apConfig->catid
                    .",\n `dmdescription`		= ".$db->quote($apConfig->dmdescription)
                    .",\n `dmdate_published`    = ".$db->quote($dmdate_published)
                    .",\n `dmowner`				= ".(int) $dmowner
                    .",\n `published`			= ".(int) $apConfig->published
                    .",\n `dmurl`				= ".$db->quote($apConfig->dmurl)
                    .",\n `dmcounter`			= ".(int) $apParams->dmcounter
                    .",\n `checked_out`			= ".(int) $apParams->checked_out
                    .",\n `checked_out_time`	= ".$db->quote($apParams->checked_out_time)
                    .",\n `approved`			= ".(int) $apConfig->approved
                    .",\n `dmthumbnail`			= ".$db->quote($apConfig->dmthumbnail)
                    .",\n `dmlastupdateon`      = ".$db->quote($dmlastupdateon)
                    .",\n `dmlastupdateby`		= ".(int) $my->id
                    .",\n `dmsubmitedby`		= ".(int) $my->id
                    .",\n `dmmantainedby`		= ".(int) $dmmantainedby
                    .",\n `dmlicense_id`		= ".(int) $apConfig->dmlicense_id
                    .",\n `dmlicense_display`	= ".(int) $apConfig->dmlicense_display
                    .",\n `access`				= ".(int) $apConfig->access
                    .",\n `attribs`				= ".$db->quote($apConfig->attribs)
                    );        
            if (!$db->query()) {
                $failed++;
            } else {
                $success++;
            }
        }

        echo 'Populate for DOCman: ';
    	echo $success . ' files added successfully, ' . $failed . ' failed.';
    }
		
}
